/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IMember;
import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.ISourceRange;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.model.impl.AbstractModelElement;
import com.aptana.editor.php.internal.model.impl.SourceRange;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.model.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractMember
extends AbstractModelElement
implements IMember {
    private IElementEntry entry;

    protected AbstractMember(IElementEntry entry) {
        this.entry = entry;
    }

    public ISourceModule getSourceModule() {
        return ModelUtils.convertModule(this.entry.getModule());
    }

    public boolean exists() {
        IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
        List<IElementEntry> entries = index.getEntries(this.entry.getCategory(), this.entry.getEntryPath());
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (IElementEntry currentEntry : entries) {
            if (!this.entry.equals(currentEntry)) continue;
            return true;
        }
        return false;
    }

    public String getElementName() {
        return ElementsIndexingUtils.getLastNameInPath(this.entry.getEntryPath());
    }

    public IType getDeclaringType() {
        if (EntryUtils.isType(this.entry)) {
            return null;
        }
        IElementEntry typeEntry = TypeUtils.getDeclaringType(this.entry);
        if (typeEntry == null) {
            return null;
        }
        return (IType)ModelUtils.convertEntry(typeEntry);
    }

    public IModelElement getParent() {
        if (!this.entry.getEntryPath().contains(Character.toString('/'))) {
            return ModelUtils.convertModule(this.entry.getModule());
        }
        String entryPathStr = this.entry.getEntryPath();
        if (entryPathStr == null || entryPathStr.length() == 0) {
            return ModelUtils.convertModule(this.entry.getModule());
        }
        Path entryPath = new Path(entryPathStr);
        if (entryPath.segmentCount() < 2) {
            return ModelUtils.convertModule(this.entry.getModule());
        }
        IPath parentPath = entryPath.removeLastSegments(1);
        List<IElementEntry> entries = this.getModuleEntries(-1, this.pathToString(parentPath));
        if (entries.size() == 0) {
            return ModelUtils.convertModule(this.entry.getModule());
        }
        return ModelUtils.convertEntry(entries.iterator().next());
    }

    public List<IModelElement> getChildren() {
        List<IElementEntry> entries = this.getModuleEntriesStartingWith(-1, this.entry.getEntryPath());
        return ModelUtils.convertEntries(entries);
    }

    public boolean hasChildren() {
        if (!this.entry.getEntryPath().contains(Character.toString('/'))) {
            return this.getModuleEntries().size() != 0;
        }
        return this.getModuleEntriesStartingWith(-1, this.entry.getEntryPath()).size() != 0;
    }

    public ISourceRange getSourceRange() {
        if (this.getEntry().getValue() instanceof AbstractPHPEntryValue) {
            return new SourceRange(((AbstractPHPEntryValue)this.getEntry().getValue()).getStartOffset());
        }
        return new SourceRange(0);
    }

    public IElementEntry getEntry() {
        return this.entry;
    }

    protected List<IElementEntry> filterByModule(List<IElementEntry> entries, IModule module) {
        if (entries == null || entries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IElementEntry currentEntry : entries) {
            if (!module.equals(currentEntry.getModule())) continue;
            result.add(currentEntry);
        }
        return result;
    }

    protected List<IElementEntry> getModuleEntries(int category, String entryPath) {
        List<IElementEntry> moduleEntries = this.getModuleEntries();
        ArrayList<IElementEntry> correctPathEntries = new ArrayList();
        if (entryPath == null || entryPath.length() == 0) {
            correctPathEntries = moduleEntries;
        } else {
            for (IElementEntry currentEntry : moduleEntries) {
                if (!entryPath.equals(currentEntry.getEntryPath()) || this.entry.equals(currentEntry)) continue;
                correctPathEntries.add(currentEntry);
            }
        }
        if (category == -1) {
            return correctPathEntries;
        }
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IElementEntry currentEntry : correctPathEntries) {
            if (currentEntry.getCategory() != category) continue;
            result.add(currentEntry);
        }
        return result;
    }

    protected List<IElementEntry> getModuleEntriesStartingWith(int category, String entryPath) {
        List<IElementEntry> moduleEntries = this.getModuleEntries();
        ArrayList<IElementEntry> correctPathEntries = new ArrayList();
        if (entryPath == null || entryPath.length() == 0) {
            correctPathEntries = moduleEntries;
        } else {
            for (IElementEntry currentEntry : moduleEntries) {
                if (!currentEntry.getEntryPath().startsWith(entryPath) || this.entry.equals(currentEntry)) continue;
                correctPathEntries.add(currentEntry);
            }
        }
        if (category == -1) {
            return correctPathEntries;
        }
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IElementEntry currentEntry : correctPathEntries) {
            if (currentEntry.getCategory() != category) continue;
            result.add(currentEntry);
        }
        return result;
    }

    protected String pathToString(IPath path) {
        if (path == null || path.segmentCount() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] segments = path.segments();
        int i = 0;
        while (i < path.segmentCount() - 1) {
            builder.append(segments[i]);
            builder.append('/');
            ++i;
        }
        builder.append(segments[segments.length - 1]);
        return builder.toString();
    }

    private List<IElementEntry> getModuleEntries() {
        IModule module = this.entry.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
        return index.getModuleEntries(module);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMember other = (AbstractMember)obj;
        return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
    }
}

